import colors from 'vuetify/es5/util/colors'
import fs from 'fs';
import path from 'path';
const { BundleAnalyzerPlugin } = require('webpack-bundle-analyzer');
const CompressionPlugin = require('compression-webpack-plugin');
const TerserPlugin = require('terser-webpack-plugin');

export default {
  router: {
    base: '/',
   // middleware: ['auth'],
    extendRoutes(routes, resolve) {
      return [
        {
          name: 'home',
          path: '/add', 
          component: resolve(__dirname, 'pages/Addbox.vue'),
          chunkName: 'pages/about/index'
        },

        {
          name: 'home',
          path: '/page-payment-and-delivery', 
          component: resolve(__dirname, 'pages/paymentanddelivery.vue'),
          chunkName: 'pages/about/index'
        },






        {
          name: 'home',
          path: '/', 
          component: resolve(__dirname, 'pages/index.vue'),
          chunkName: 'pages/about/index'
        },
        {
          name: 'About',
          path: '/page-about-us', 
          component: resolve(__dirname, 'pages/aboutus.vue'),
          chunkName: 'pages/about/index'
        },
        {
          name: 'Orlando',
          path: '/page-orlando-showroom', 
          component: resolve(__dirname, 'pages/page-orlando-showroom.vue'),
          chunkName: 'pages/about/index'
        },

        {
          name: 'termsandconditions',
          path: '/page-terms-and-conditions', 
          component: resolve(__dirname, 'pages/termsandconditions.vue'),
          chunkName: 'pages/about/index'
        },

        {
          name: 'page-for-dealers',
          path: '/page-for-dealers', 
          component: resolve(__dirname, 'pages/page-for-dealers.vue'),
          chunkName: 'pages/about/index'
        },

        {
          name: 'cookiespolicy',
          path: '/page-privacy-policy', 
          component: resolve(__dirname, 'pages/cookiespolicy.vue'),
          chunkName: 'pages/about/index'
        },

       


        








        {
          name: 'Blog',
          path: '/blog', 
          component: resolve(__dirname, 'pages/blog.vue'),
          chunkName: 'pages/blog/index'
        },
        {
          name: 'Blog',
          path: '/blog-:id', 
          component: resolve(__dirname, 'pages/blogCat.vue'),
          chunkName: 'pages/blog/index'
        },
        {
          name: 'Career',
          path: '/career', 
          component: resolve(__dirname, 'pages/career.vue'),
          chunkName: 'pages/career/index'
        },
        {
          name: 'Contact',
          path: '/page-contact', 
          component: resolve(__dirname, 'pages/page-contact.vue'),
          chunkName: 'pages/about/index'
        },
        {
          name: 'Help',
          path: '/page-help', 
          component: resolve(__dirname, 'pages/help.vue'),
          chunkName: 'pages/about/index'
        },
       
        {
          name: 'product',
          path: '/products-:id', 
          component: resolve(__dirname, 'pages/products/_id.vue'),
          chunkName: 'pages/about/index'
        },
        {
          name: 'category',
          path: '/category-:id', 
          component: resolve(__dirname, 'pages/category/_id.vue'),
          chunkName: 'pages/about/index'
        },
        {
          name: 'category',
          path: '/Blog/:id', 
          component: resolve(__dirname, 'pages/blog/_id.vue'),
          chunkName: 'pages/about/index'
        },
        {
          name: 'cart',
          path: '/cart', 
          component: resolve(__dirname, 'pages/cart.vue'),
          chunkName: 'pages/cart'
        },
        {
          name: 'address',
          path: '/checkout/address', 
          component: resolve(__dirname, 'pages/checkout/address.vue'),
          chunkName: 'pages/cart'
        },
        {
          name: 'check',
          path: '/check', 
          component: resolve(__dirname, 'pages/Check.vue'),
          chunkName: 'pages/cart'
        },
        {
          name: 'Thankyou',
          path: '/thankyou', 
          component: resolve(__dirname, 'pages/Thankyou.vue'),
          chunkName: 'pages/cart'
        },
        {
          name: 'Installers',
          path: '/page-installers', 
          component: resolve(__dirname, 'pages/page-installers.vue'),
          chunkName: 'pages/cart'
        },
        {
          name: 'Search',
          path: '/search-product', 
          component: resolve(__dirname, 'pages/search-product.vue'),
          chunkName: 'pages/cart'
        },
        {
          name: 'User',
          path: '/account/dashboard', 
          component: resolve(__dirname, 'pages/account/dashboard/customer.vue'),
          chunkName: 'pages/cart'
        },
        {
          name: 'User',
          path: '/dealer/dashboard', 
          component: resolve(__dirname, 'pages/dealer/dashboard/dealer.vue'),
          chunkName: 'pages/cart'
        },
        {
          name: 'User',
          path: '/related_bmw-accessories_category_bmw-accessories_:id', 
          component: resolve(__dirname, 'pages/thankyou.vue'),
          chunkName: 'pages/cart'
        },
        {
          name: 'User',
          path: '/bmw-part-order', 
          component: resolve(__dirname, 'pages/BmwPartOrder.vue'),
          chunkName: 'pages/cart'
        },
       
      ]
    }
  },
  build: {
    extractCSS: true,
    analyze: false,
    optimizeCSS: true,
    splitChunks: {
      layouts: true,
      pages: true,
      commons: true,
    },
    optimization: {
      minimize: true,
      minimizer: [
        new TerserPlugin({
          parallel: true,
          terserOptions: {
            compress: {
              drop_console: true,
            },
          },
        }),
      ],
      splitChunks: {
        chunks: 'all',
      },
    },
    extend(config, { isDev, isClient }) {
      if (!isDev && isClient) {
        config.plugins.push(
          new CompressionPlugin({
            test: /\.(js|css|html|svg)$/,
            threshold: 10240,
            minRatio: 0.8,
          })
        );
      }
    },
  },
  //devtools: true, // Enabling devtools
 // profile: true ,  // Profiling in development mode

  // Global page headers: https://go.nuxtjs.dev/config-head
  head: {
    titleTemplate: '%s - | BimmerTech',
    title: 'Retrofits, Upgrades and Parts for BMW',
    htmlAttrs: {
      lang: 'en'
    },
    meta: [
      { charset: 'utf-8' },
      { name: 'viewport', content: 'width=device-width, initial-scale=1' },
      { hid: 'description', name: 'description', content: '' },
      { name: 'format-detection', content: 'telephone=no' }
    ],
    link: [
      { rel: 'icon', type: 'image/x-icon', href: '/favicon.ico' }
    ]
  },
  ssr:true,
  // Global CSS: https://go.nuxtjs.dev/config-css
  css: ["~/Public/main.css",
    "~/Public/slider.css",

  ],
  // Plugins to run before rendering page: https://go.nuxtjs.dev/config-plugins
  plugins: [

    { src: '~/plugins/v-tooltip.js', ssr: false },
    { src: '~/plugins/device-detection.js', ssr: true },
    { src: '~/plugins/VueSlickCarousel.js', ssr: false },
    { src: '~/plugins/Click-outside.js', ssr: false },
    { src: '~/plugins/jquery.js', mode: 'client' },  // Ensure the plugin is only loaded on the client-side
    { src: '~/plugins/vue-image-zoomer.js', mode: 'client' },
    { src: '~/plugins/splideVue.js', mode: 'client' },


   
    // { src: '~/plugins/vue-awesome-swiper.js', mode: 'client' },
   

  ],
  // plugins: ['~/plugins/axios'],
 

  // Auto import components: https://go.nuxtjs.dev/config-components
  components: true,

  // Modules for dev and build (recommended): https://go.nuxtjs.dev/config-modules
  buildModules: [
    // https://go.nuxtjs.dev/vuetify
    '@nuxtjs/axios',
    '@nuxtjs/auth-next',
    '@nuxtjs/vuetify',
   
  ],

  // Modules: https://go.nuxtjs.dev/config-modules
  modules: [
   
  ],axios: {
    baseURL: 'http://newshop.testshop1.bimmer-tech.net/', // Replace with your Sylius domain
  },
  server: {
    //host: '192.168.18.15',
    // port: 35000,
    // https: {
    //   key: fs.readFileSync(path.resolve(__dirname, '192.168.18.15.key')),
    //   cert: fs.readFileSync(path.resolve(__dirname, '192.168.18.15.crt')),
    // },
  },
  auth: {
    strategies: {
      local: {
        token: {
          property: 'token',
          global: true,
          required: true,
          type: 'Bearer'
        },
        user: {
          property: false, // Property name where the user info is stored in the response from login.
          autoFetch: true
        },
        endpoints: {
          login: { url: '/api3/login_check', method: 'post' },
          logout: { url: '/api3/logout', method: 'post' }, // If your API supports it
          user: { url: '/api3/user/set/login', method: 'post' }
        }
      }
    },
    redirect: {
      login: false,   // Do not redirect after login
      logout: false,  // Do not redirect after logout
      home: false,    // Do not redirect to home after login
      callback: '/login' // Callback URL after OAuth login (if needed)
    }
  },
  // auth: {
  //   strategies: {
  //     local: false,
  //     oauth2: {
  //       scheme: 'oauth2',
  //       endpoints: {
  //         authorization: '/oauth/v2/auth',
  //         token: '/oauth/v2/token',
  //         userInfo: '/api/user', // Endpoint to fetch the user info
  //       },
  //       token: {
  //         property: 'access_token',
  //         type: 'Bearer',
  //         maxAge: 1800,
  //       },
  //       refreshToken: {
  //         property: 'refresh_token',
  //         maxAge: 60 * 60 * 24 * 30,
  //       },
  //       responseType: 'token',
  //       grantType: 'password',
  //       clientId: '3sg06p2hjgkk8004ks0os0sc8gccw004kkkwo80oc0g8gskw80', // Replace with your OAuth client ID
  //       clientSecret: '48stzbnvx5esssosc4w4s8ocso0ggwcc48gg884s8s0g4kwow0', // Replace with your OAuth client secret
  //       scope: ['default'], // Adjust the scope as necessary
  //     },
  //   },
  // },

  // Vuetify module configuration: https://go.nuxtjs.dev/config-vuetify
  vuetify: {
    customVariables: [],
    options: {
      customProperties: true,
    },
    breakpoint: {
      thresholds: {
        xs: 340,
        sm: 540,
        md: 800,
        lg: 1280,
      },
      scrollBarWidth: 24,
    },
    theme: {
      light: true,
      themes: {
        light: {
          primary: '#1CA3C2',
          accent: '#0C54AD',
          secondary: '#5b9ba9',
          warning: colors.amber.base,
          error: '#F23720',
          success: '#16D28D',
          footer:'#FFC107',
          header:'#363636',
          white:'#ffffff',
          green:'#14CF8A',
          grey:"A2A2A2",
          grey2:"#DCDCDC",
          grey3:"#1E1E1E",
          grey4:"#AAAAAA",
          grey5:"#C5C5C5",
          grey6:"rgba(200, 200, 200, 1)",
          greylighten6:"#F1F1F1",
          listFont:'#8F8F8F',
          cardText:'#5b9ba9',
          red:'#FF2F00',
          black:'#212121',
          black1:'#212121',
          info:'#2BD18F',
          grey6:"#C8C8C8",
          grey7:"#B3B3B3",
          brown1:'#757575',
          Gainsboro:'#e8e8e8',
          yellowNew:'#FFC107'


        }
      }
    },
  
  },

}
